//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//  Copyright (c) 2018-2019 Michele Morrone
//  All rights reserved.
//
//  https://michelemorrone.eu - https://BrutPitt.com
//
//  me@michelemorrone.eu - brutpitt@gmail.com
//  twitter: @BrutPitt - github: BrutPitt
//  
//  https://github.com/BrutPitt/glslSmartDeNoise/
//
//  This software is distributed under the terms of the BSD 2-Clause license
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

#define vec2 float2
#define vec4 float4
#define rgb xyz
#define rgba xyzw

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

#define INV_SQRT_OF_2PI 0.3989422804014326779399  // 1.0/SQRT_OF_2PI
#define INV_PI          0.3183098861837906715378

float4 GaussDeNoise(__read_only image2d_t input,vec2 uv, int radius, float threshold,vec2 resolution)
{   
    float sigma = sqrt((float)(radius)/2.0f);
    float invSigmaSquare = 0.5f / (sigma * sigma+ 0.000001f);  
    
    float invThresholdSquare = 0.5f / (threshold * threshold+ 0.000001f);    
    float invThresholdSqrt2PI = INV_SQRT_OF_2PI / (threshold+ 0.000001f);   
    
    float4 centrColor = read_imagef(input,sampler,uv);
    
    float Z = 0.0f;
    float4 ColorSum = (float4)(0.0f);
    for(int x =-radius; x <= radius; x++) {       
        for(int y =-radius; y <= radius; y++) {
            vec2 d = (vec2)(x,y)/resolution;

            float blurFactor = exp( -dot(d , d) * invSigmaSquare ) * invSigmaSquare;
            float4 current = read_imagef(input,sampler,uv+d);           

            float4 dC = current-centrColor;
            float deltaFactor = exp( -dot(dC, dC) * invThresholdSquare) * invThresholdSqrt2PI * blurFactor;
                                 
            Z += deltaFactor;
            ColorSum += deltaFactor*current;
        }
    }
    return ColorSum/Z;
}

__kernel void MAIN(
      __read_only image2d_t input,
      __write_only image2d_t dest_data,
      __global FilterParam* param,
	  int alpha,
      int threshold,
      int radius)
{    
    int W = get_global_size(0);
	int H = get_global_size(1);
    float2 resolution = (float2)(W,H);
    int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));

    vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 tc = ((float2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f))/resolution.xy;

    tc = (float2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
    float4 orig = read_imagef(input, sampler, tc);  	
	float thresholdf = (float)(threshold) / 100.0f;
	float factor = resolution.x / 640.0f;
	radius *= factor;
    float4 texel =  GaussDeNoise( input,tc, radius, thresholdf, resolution);
	texel = clamp(texel,0.0f,1.0f);
	texel.w = orig.w;
    
    float4 retColor =  mix( texel, orig, 1.0f - (float)(alpha)/100.0f );
    write_imagef(dest_data,gl_FragCoord,retColor);
}

